<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Configuration;
use PSpell\Config;

class ConfigurationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Meta Group
        Configuration::insert([
            [
                "group" => "Meta",
                "key" => "site_name",
                "value" => "My Awesome Site",
                "description" => "The name of the site",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Meta",
                "key" => "site_url",
                "value" => "https://example.com",
                "description" => "The URL of the site",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Meta",
                "key" => "site_logo",
                "value" => "/images/logo.png",
                "description" => "Path to the site logo",
                "type" => "image",
                "options" => null,
            ],
            [
                "group" => "Meta",
                "key" => "site_favicon",
                "value" => "/images/logo.png",
                "description" => "Path to the site favicon.",
                "type" => "image",
                "options" => null,
            ],
            [
                "group" => "Meta",
                "key" => "site_tags",
                "value" => "gaming, community, forums",
                "description" => "Site meta tags",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Meta",
                "key" => "site_maintenance",
                "value" => "0",
                "description" => "Enable maintenance mode",
                "type" => "boolean",
                "options" => null,
            ],
        ]);

        // Colour
        Configuration::insert([
            [
                "group" => "Design",
                "key" => "primary_color",
                "value" => "#4B8BFF",
                "description" => "Hex code of the main accent.",
                "type" => "color",
                "options" => null,
            ],
            [
                "group" => "Design",
                "key" => "primary_dark",
                "value" => "#4179E6",
                "description" => "Primary dark colour",
                "type" => "color",
                "options" => null,
            ],
            [
                "group" => "Design",
                "key" => "primary_light",
                "value" => "#80A9FF",
                "description" => "Primary light colour",
                "type" => "color",
                "options" => null,
            ],
        ]);

        // General
        Configuration::insert([
            [
                "group" => "General",
                "key" => "steam_group",
                "value" => "",
                "description" => "Steam Group",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "General",
                "key" => "discord_invite",
                "value" => "",
                "description" => "Discord Invite Link",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "General",
                "key" => "show_legal_footer",
                "value" => "false",
                "description" => "Show Legal tabs on footer",
                "type" => "boolean",
                "options" => null,
            ],
        ]);

        // Home Page Group
        Configuration::insert([
            [
                "group" => "Home Page",
                "key" => "tag_line",
                "value" => "Welcome to the best community!",
                "description" => "Tagline displayed on homepage",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_1_enabled",
                "value" => "1",
                "description" => "Enable Home Box 1",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_1_fa_icon",
                "value" => "fa-star",
                "description" => "FontAwesome icon for Home Box 1",
                "type" => "icon",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_1_title",
                "value" => "Quality Content",
                "description" => "Title for Home Box 1",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_1_text",
                "value" => "We provide top-quality content daily.",
                "description" => "Text for Home Box 1",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_2_enabled",
                "value" => "1",
                "description" => "Enable Home Box 2",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_2_fa_icon",
                "value" => "fa-users",
                "description" => "FontAwesome icon for Home Box 2",
                "type" => "icon",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_2_title",
                "value" => "Strong Community",
                "description" => "Title for Home Box 2",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_2_text",
                "value" => "Join our ever-growing, vibrant community!",
                "description" => "Text for Home Box 2",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_3_enabled",
                "value" => "1",
                "description" => "Enable Home Box 3",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_3_fa_icon",
                "value" => "fa-gamepad",
                "description" => "FontAwesome icon for Home Box 3",
                "type" => "icon",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_3_title",
                "value" => "Exciting Games",
                "description" => "Title for Home Box 3",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_3_text",
                "value" => "Enjoy a wide variety of games and competitions.",
                "description" => "Text for Home Box 3",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_4_enabled",
                "value" => "1",
                "description" => "Enable Home Box 4",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_4_fa_icon",
                "value" => "fa-heart",
                "description" => "FontAwesome icon for Home Box 4",
                "type" => "icon",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_4_title",
                "value" => "We Care",
                "description" => "Title for Home Box 4",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_box_4_text",
                "value" => "We value and listen to every community member.",
                "description" => "Text for Home Box 4",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "servers_enabled",
                "value" => "1",
                "description" => "Enable servers section",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "news_enabled",
                "value" => "1",
                "description" => "Enable news section",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "news_max_news",
                "value" => "3",
                "description" => "Max number of news items to display",
                "type" => "number",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_call_to_action_enabled",
                "value" => "1",
                "description" => "Enable call to action section",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_call_to_action_title",
                "value" => "Join Us Today!",
                "description" => "Call to Action title",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Home Page",
                "key" => "home_call_to_action_text",
                "value" => "Sign up and become part of our amazing community!",
                "description" => "Call to Action text",
                "type" => "text",
                "options" => null,
            ],
        ]);

        // Store - Updated PayPal Configuration
        Configuration::insert([
            [
                "group" => "Store",
                "key" => "store_enabled",
                "value" => "true",
                "description" => "Enable Store",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_sandbox",
                "value" => "true",
                "description" => "Sandbox Mode",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_currency",
                "value" => "GBP",
                "description" => "Store Currency",
                "type" => "select",
                "options" => "USD,EUR,GBP,PLN,CAD,AUD,JPY,CHF,SEK,NOK,DKK",
            ],
            [
                "group" => "Store",
                "key" => "store_paypal_enabled",
                "value" => "true",
                "description" => "Enable PayPal",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_paypal_client_id",
                "value" => "",
                "description" => "PayPal Client ID (from PayPal Developer Dashboard)",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_paypal_client_secret",
                "value" => "",
                "description" => "PayPal Client Secret (from PayPal Developer Dashboard)",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_paypal_webhook_id",
                "value" => "",
                "description" => "PayPal Webhook ID (optional - for webhook verification)",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_stripe_enabled",
                "value" => "false",
                "description" => "Enable Stripe",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_stripe_secret",
                "value" => "",
                "description" => "Stripe Secret Key",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_stripe_public",
                "value" => "",
                "description" => "Stripe Public Key",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_stripe_webhook_secret",
                "value" => "",
                "description" => "Stripe Webhook Secret",
                "type" => "text",
                "options" => null,
            ],
            [
                "group" => "Store",
                "key" => "store_terms_of_service",
                "value" => $this->getDefaultTermsOfService(),
                "description" => "Terms of Service",
                "type" => "text",
                "options" => null,
            ],
        ]);

        // Server
        Configuration::insert([
            [
                "group" => "Keys",
                "key" => "steam_apikey",
                "value" => "",
                "description" => "Steam API Key",
                "type" => "text",
                "options" => null,
            ],
        ]);

        // News
        Configuration::insert([
            [
                "group" => "News",
                "key" => "toggle_news",
                "value" => "true",
                "description" => "Toggle News",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "News",
                "key" => "max_news",
                "value" => "3",
                "description" => "Maximum news articles on home page.",
                "type" => "number",
                "options" => null,
            ],
        ]);

        // Forum
        Configuration::insert([
            [
                "group" => "Forum",
                "key" => "forum_max_characters",
                "value" => "1000",
                "description" => "Maximum characters allowed per forum post",
                "type" => "number",
                "options" => null,
            ],
            [
                "group" => "Forum",
                "key" => "forum_max_replies",
                "value" => "1000",
                "description" => "Maximum replies allowed per thread",
                "type" => "number",
                "options" => null,
            ],
            [
                "group" => "Forum",
                "key" => "forum_autolock_thread",
                "value" => "false",
                "description" => "Auto-lock threads after inactivity",
                "type" => "boolean",
                "options" => null,
            ],
            [
                "group" => "Forum",
                "key" => "forum_autolock_thread_days",
                "value" => "30",
                "description" => "Days until a thread auto-locks",
                "type" => "number",
                "options" => null,
            ],
            [
                "group" => "Forum",
                "key" => "forum_allow_activities",
                "value" => "true",
                "description" => "Show Forum activity on profile",
                "type" => "boolean",
                "options" => null,
            ],
        ]);

        // Footer
        Configuration::insert([
            [
                "group" => "Footer",
                "key" => "footer_text",
                "value" => "© 2025 My Awesome Site. All rights reserved.",
                "description" => "Footer copyright",
                "type" => "text",
                "options" => null,
            ],
        ]);
    }
    private function getDefaultTermsOfService()
    {
        return '<div class="tos-section">
            <h2>1. Introduction</h2>
            <p>Welcome to our game server store. These Terms of Service ("Terms") govern your access to and use of our website, services, and purchases. By accessing or using our services, you agree to be bound by these Terms.</p>
        </div>

        <div class="tos-section">
            <h2>2. Definitions</h2>
            <p>Throughout these Terms, the following definitions apply:</p>
            <ul>
                <li><strong>"We", "us", "our"</strong> refers to the operators of this website and service.</li>
                <li><strong>"You", "your"</strong> refers to the user accessing or using our services.</li>
                <li><strong>"Service", "services"</strong> refers to all features, functionalities, and offerings available through our website.</li>
                <li><strong>"Package"</strong> refers to any digital item, benefit, or service offered for purchase.</li>
                <li><strong>"Server"</strong> refers to our game servers where the purchased packages apply.</li>
            </ul>
        </div>

        <!-- Additional sections of the ToS would continue here -->
        <div class="tos-section">
            <h2>3. Account Registration</h2>
            <p>To purchase packages, you must have a valid Steam account. You are responsible for maintaining the security of your account and for all activities that occur under your account.</p>
        </div>

        <div class="tos-section">
            <h2>4. Purchases and Payments</h2>
            <p>By making a purchase, you agree that all sales are final and non-refundable except where required by law.</p>
        </div>';
    }
}